n = 4 # number of species
m = 2 # number of resources

# data from Table 1 in Tilman (1981)
h_Tilman = t(matrix(c(1.5,0.011,2.2,0.006,
                      19.7,0.003,19.0,0.008),m,n))
r_Tilman = t(matrix(c(0.62,0.80,0.78,0.59,
                      1.11,0.65,0.74,0.36),m,n))
Q_Tilman = t(matrix(c(9.7e-7,4.7e-8,1.5e-6,2.6e-8,
                      5.8e-5,1.1e-7,6.3e-6,1.9e-7),m,n))
D = 0.25

# resource input concentrations
Ss = list(c(12,10), c(41.3,0.58), c(209,0.2))
n_patch = length(Ss)
par(mfrow=c(1,n_patch))

for ( i in 1:n_patch )
  {
  X0 = c(1e6,1e6,1e6,1e6,Ss[[i]]) # initial conditions
  parms = list(r=r_Tilman,h=h_Tilman,Q=Q_Tilman,S=Ss[[i]],
               D=D)
  ts=seq(0,3000,length.out=1000)
  
  # run the differential equation solver to get time series
  X_t = ode(X0,ts,Monod_derivatives,parms=parms)
  
  plot(X_t[,1],X_t[,2]/1000,xlab='Time (days)',
       ylim=c(10^0,10^5),ylab='Population density (cell/mL)',
       col='red',type='l',log='y')
  lines(X_t[,1],X_t[,3]/1000,col='cyan')
  lines(X_t[,1],X_t[,4]/1000,col='forest green')
  lines(X_t[,1],X_t[,5]/1000,col='blue')
  } 
